cd "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/"

clear
global adj_series "Without CRN"


*USCRN Importer
*run crn_importer_from_ftp.do

*USHCN Importer
*global type "raw.tmax" //do for all combinations
*run ushcn_data_importer_raw.do

global type "FLs.52j.tmax"
global folder "Without CRN"
*run ushcn_data_importer_adj.do

*Grid cell assigner
/*
*NOTE DONT RUN WITHOUT ADDING START AND END DATES
import delimited "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/ushcn-v2.5-stations.csv", clear
gen station_id = substr(v1, 4, 999)
rename v2 lat
rename v3 lon
keep station_id lat lon
run grid_cell_assigner.do
destring station_id, replace force
sort station_id
*save ushcn_metadata.dta, replace

use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/crn_monthly_9_28_15.dta", clear
run grid_cell_assigner.do
sort station_id
*save uscrn_metadata.dta, replace

use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/crn_monthly_9_28_15.dta", clear
rename max tmax
rename min tmin
rename avg tavg
save "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/crn_monthly_9_28_15.dta", replace
*/

foreach type in tavg tmin tmax {

global anom_start = 2004
global anom_end = 2014
global station_years = 5

global file ushcn_metadata
use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN $adj_series FLs.52j.`type'.dta", clear
run anomaly_grid_cell_calc.do
rename avg ushcn_`type'_adj
drop if date == . | ushcn_`type'_adj == .
sort gridbox date grid_weight
save ushcn_`type'_adj_gridded.dta, replace

global file ushcn_metadata
use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN raw.`type'.dta", clear
run anomaly_grid_cell_calc.do
rename avg ushcn_`type'_raw
drop if date == . | ushcn_`type'_raw == .
sort gridbox date grid_weight
save ushcn_`type'_raw_gridded.dta, replace

global file uscrn_metadata
use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/crn_monthly_9_28_15.dta", clear
replace `type' = . if `type' == -9999
keep station_id year month `type'
gen date = ym(year, month)
format date %tm
rename `type' avg
run anomaly_grid_cell_calc.do
rename avg uscrn_`type'
drop if date == . | uscrn_`type' == .
sort gridbox date grid_weight
merge gridbox date grid_weight using ushcn_`type'_adj_gridded
keep if _merge == 3
drop _merge

sort gridbox date grid_weight
merge gridbox date grid_weight using ushcn_`type'_raw_gridded
drop if _merge == 2
drop _merge

sort gridbox date grid_weight
save merged_results_`type'.dta, replace

collapse (mean) uscrn_`type' ushcn_`type'_adj ushcn_`type'_raw [iweight = grid_weight], by (date)

keep if year(dofm(date)) >= 2004

gen raw_minus_crn = ushcn_`type'_raw - uscrn_`type'
gen adj_minus_crn = ushcn_`type'_adj - uscrn_`type'

sort date
#delimit ;
twoway 
	(line ushcn_`type'_raw date, lwidth(thin) lcolor(blue))
	(line ushcn_`type'_adj date, lwidth(thin) lcolor(red))
	(line uscrn_`type' date, lwidth(thin) lcolor(green))
    ,
    ytitle("`type' Anomaly (Deg. C)", size(medsmall))
  	xtitle("", size(small))
  	xlabel(528 "2004" 552 "2006" 576 "2008" 600 "2010" 624 "2012" 648 "2014",labsize(medium))
  	ylabel(4(-2)-3, gmax glcolor(black) glpattern(dot) labsize(medium)) 
  	graphregion(color(white) lcolor(ebg))
  	legend(region(fcolor(white) lcolor(white)) size(small) position(12) label(1 "USHCN Raw")  label(2 "USHCN Adjusted") label(3 "USCRN") order(1 2 3) col(3))
	saving(conus_gridded_`type', replace)
	;
#delimit cr

sort date
#delimit ;
twoway 
	(line raw_minus_crn date, lwidth(thin) lcolor(blue))
	(line adj_minus_crn date, lwidth(thin) lcolor(red))
    ,
    ytitle("`type' Difference (Deg. C)", size(medsmall))
  	xtitle("", size(small))
  	xlabel(528 "2004" 552 "2006" 576 "2008" 600 "2010" 624 "2012" 648 "2014",labsize(medium))
  	ylabel(-0.4(0.2)0.4, gmax glcolor(black) glpattern(dot) labsize(medium)) 
  	graphregion(color(white) lcolor(ebg))
  	legend(region(fcolor(white) lcolor(white)) size(small) position(12) label(1 "Raw minus CRN")  label(2 "Adj minus CRN") order(1 2) col(2))
	saving(conus_gridded_`type'_diff, replace)
	;
#delimit cr

}


grc1leg conus_gridded_tmax.gph conus_gridded_tmin.gph conus_gridded_tavg.gph conus_gridded_tmax_diff.gph conus_gridded_tmin_diff.gph conus_gridded_tavg_diff.gph, colfirst cols(2) row(3) position(6) legendfrom(conus_gridded_tavg.gph) graphregion(fcolor(white)) imargin(0 0 0 0)

graph export "CONUS average combined.png", replace width(1000)

